//
//  OPDataAccessorBase.h
//  Image Downloader
//
//  Created by Nathan Van Fleet on 2015-06-01.
//  Copyright (c) 2015 Nathan Van Fleet. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "OPDataModuleProtocol.h"

// Object that either loads data from disk or the web
@interface OPDataAccessorBase : NSObject <OPDataModule>
@property (nonatomic, weak) id <OPDataModuleDelegate> delegate;
+ (instancetype)accessor;
@end

// Object that does a process on data from its inputObject
@interface OPDataProcessorBase : NSObject <OPDataModuleProcessor>
@property (nonatomic,strong) id inputObject;
@property (nonatomic, weak) id <OPDataModuleDelegate> delegate;
+ (instancetype)processor;
@end
